using System;
using System.IO;
using System.Windows.Forms;
using BeWise.SharpBuilderTools;

namespace BeWise.SharpBuilderTools.Ant
{
	public class Ant: BaseAnt
	{

		// *************************************************************************
		//                           Constructor
		// *************************************************************************

		public Ant()
		{
		}

		// *************************************************************************
		//                              Protected
		// *************************************************************************

        protected override string GetCommandLine ()
		{
			return Consts.ANT_EXE_NAME;
		}

		protected override string GetName ()
		{
            return "Ant";
		}

		protected override string GetAntPath () {
			string _Path = Main.Configuration.AntPath;

			if ((_Path.Length > 0) && (_Path[_Path.Length -1] != '\\')) {
				_Path += @"\";
			}

			return _Path;
		}

		// *************************************************************************
		//                              Public
		// *************************************************************************


		public override BaseAntProject CreateAntProject(string aFileName) {
			return new AntProject(aFileName);
		}

		public override bool IsAntFile(string aFileName){
			return Path.GetFileName(aFileName).ToUpper() == "Build.xml".ToUpper();
		}

	}
}
